

export class EmailEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/email/')}}" class="fa fa-chevron-circle-left"></a>
				
				<a href="javascript:void(0);" [onclick]="widget.sendMessage" class="fa fa-paper-plane"></a>
				
				<a href="javascript:void(0);" ez-if="isNew == false" [onclick]="widget.delete_Click" class="fa fa-trash"></a>
				
				<a href="javascript:void(0);" [onclick]="widget.save_Click" class="fa fa-save"></a>
			</div>
			
			<h1>{{ isNew ? 'E-mail maken' : 'E-mail bewerken' }}</h1>
		</div>
		
		<form id="frmEmailEdit">
			<input type="hidden" name="emailMessageId" value="{{email.emailMessageId}}" />
			
			<div ez-subtemplate="errorlist">
			</div>
		
			<div class="email-files">
				Bestanden
				
				<ul ez-for="email.files" ez-item="file">
					<li file-id="{{file.emailFileId}}">
						<a href="javascript:void(0);" [onclick]="widget.openFile">{{file.filename}}</a>
						<a href="javascript:void(0);" [onclick]="widget.deleteFile"><span class="fa fa-remove remove-file"></span></a>
					</li>
					
				</ul>
				
				<div>
					<input type="file" name="f" />
				</div>
				
			</div>
			
			
			<table>
				<tr>
					<th>Id</th>
					<td>
						{{email.emailMessageId ?? 'Nieuwe e-mail'}}
					</td>
				</tr>
				<tr>
					<th>Van</th>
					<td>{{ emailSettings.fromName }} &lt;{{emailSettings.fromEmail}}&gt;</td>
				</tr>
				<tr>
					<th>Status</th>
					<td>{{ _('emailStatus.'+email.status) }}</td>
				</tr>
				<tr>
					<th>Klant</th>
					<td>
						<ez-table-selector name="customerId" 
												label="" 
												url="{{appUrl('/service/customers.do?a=tableSearch')}}"
												[value]="email.customerId" 
												[valueText]="email.customerName"></ez-table-selector>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<table>
							<tbody id="emailTos" ez-for="email.tos" ez-item="to">
								<tr>
									<td>
										<ez-select [value]="to.toType" class="to-type" label="">
											<option value="to">To</option>
											<option value="cc">Cc</option>
											<option value="bcc">Bcc</option>
										</ez-select>
									</td>
									<td>
										<div class="email-to-input">
											<ez-text class="to-name" [value]="to.toName" label="" placeholder="Naam"></ez-text>
											<ez-email class="to-email" [value]="to.toEmail" label="" placeholder="@ E-mailadres"></ez-text>
										</div>
									</td>
									<td>
										<a href="javascript:void(0);" [onclick]="widget.deleteToAddress"><span class="fa fa-remove row-delete"></span></a>
									</td>
								</tr>
							</tbody>
						</table>
						
						<a href="javascript:void(0);" [onclick]="widget.addToAddress">Toevoegen</a>
					</td>
				</tr>
				<tr>
					<th>Onderwerp</th>
					<td>
						<ez-text name="subject" [value]="email.subject" label=""></ez-text>
					</td>
				</tr>
			</table>
			
			<ez-textarea name="textContent" [value]="email.textContent" label=""></ez-textarea>
		</form>
		
	`;
	
	ezTpl = null;
	container = null;
	isNew = true;
	
	emailSettings = null;
	email = {
		status: 'new',
		tos: [ {} ]
	};
	
	
	init(c) {
		loadCss( '/static/app/widget/email/css/email.css' );
		
		this.container = c;
		
		this.loadSettings();
	}
	
	loadSettings() {
		postUrl('/service/email/message.do', {
			a: 'config'
		}).then( async function(e) {
			let json = await e.json();
			console.log(json);
			this.emailSettings = json.emailSettings;
			
			if (getUrlParam('id')) {
				this.isNew = false;
				this.loadEmail( getUrlParam('id') );
			}
			else {
				this.render();
			}
		}.bind(this));
	}
	
	loadEmail(emailId) {
		console.log('loadEmail');
		postUrl('/service/email/message.do', {
			emailMessageId: emailId,
			a: 'view'
		}).then( async function(e) {
			let json = await e.json();
			
			this.email = json.emailMessage;
			
			this.render();
		}.bind(this));
		
	}
	
	
	
	render() {
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('email', this.email);
		this.ezTpl.setVar('emailSettings', this.emailSettings);
		
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.render();
		
		console.log('jow');
		var strPlugins = 'paste,code,link,media,paste,table,textcolor,wordcount,contextmenu,colorpicker';
//		strPlugins += ',fullpage';
			
		$('textarea[name=textContent]').tinymce({
			plugins: strPlugins,
			paste_data_images: true
		});
		
		$('#frmEmailEdit input[name=f]').on('change', function() {
			this.uploadFile();
		}.bind(this));
		
		$('#frmEmailEdit ez-table-selector[name=customerId]').on('change', function(evt) {
			let cid = evt.target.value;
			
			if (!cid)
				return;
			
			// lookup customer
			postUrl('/service/customers.do', {
				a: 'view',
				customerId: cid
			}).then( async function(e) {
				let json = await e.json();
					
				if (json.customer && json.customer.emails.length > 0) {
					let e = json.customer.emails[0].emailAddress;
					
					let found = false;
					
					let emptyRecord = null;
					
					// check if mail is set
					$('#emailTos tr').each(function(index, node) {
						let rec_name = $.trim( $(node).find('.to-name input').val() );
						let rec_mail = $.trim( $(node).find('.to-email input').val() );
						if (e.toLowerCase() == rec_mail.toLowerCase())
							found = true;
						
						if (emptyRecord == null && rec_name == '' && rec_mail == '') {
							emptyRecord = node;
						}
					});
					
					
					
					// or set mailadres in empty record, or create record
					if (found == false) {
						if (emptyRecord != null) {
							$(emptyRecord).find('.to-name input').val( json.customer.customerName );
							$(emptyRecord).find('.to-email input').val( e );
						}
						else {
							let tb = document.querySelector('tbody#emailTos');
							tb.eztemplate.createRecord( {
								toName: json.customer.customerName,
								toEmail: e
							} );
						}
					}
				}
			}.bind(this));
			
		}.bind(this));
	}
	
	
	addToAddress() {
		let tb = document.querySelector('tbody#emailTos');
		tb.eztemplate.createRecord( {} );
	}
	
	deleteToAddress(evt) {
		$(evt.target).closest('tr').remove();
	}
	
	
	uploadFile() {
		this.save_Click();
	}
	
	openFile(evt) {
		let fileid = $(evt.target).closest('li').attr('file-id');
		
		window.open( appUrl('/service/email/message.do?a=downloadFile&id=' + fileid), '_blank' );
	}
	
	deleteFile(evt) {
		let li = $(evt.target).closest('li');
		let fileid = li.attr('file-id');
		li.remove();
		
		postUrl('/service/email/message.do', {
			a: 'deleteFile',
			fileId: fileid
		});
	}
	
	
	async save_Click( opts ) {
		
		opts = opts ? opts : {};
		
		let frm = $('#frmEmailEdit');
		
		showLoadingForm( '#frmEmailEdit' );
		
		let o = {};
		o.a = 'save';
		
		o.emailMessageId = frm.find('input[name=emailMessageId]').val();
		o.customerId = frm.find('input[name=customerId]').val();
		o.tos = [];
		$('tbody#emailTos tr').each(function(index, node) {
			let to = {};
			to.type = $(node).find('.to-type select').val();
			to.name = $(node).find('.to-name input').val();
			to.email = $(node).find('.to-email input').val();
			o.tos.push( to );
		});
		
		o.subject = frm.find('input[name=subject]').val();
		o.textContent = frm.find('textarea[name=textContent]').val();
		
		// TODO: files..
		
		let fd = new FormData();
		fd.append('a', 'save');
		fd.append('emailMessageId', o.emailMessageId);
		if (opts.send)
			fd.append('sendMail', 1);
		fd.append('data', JSON.stringify(o));
		
		let files = document.querySelector('#frmEmailEdit input[name=f]');
		if (files.files.length > 0) {
			fd.append("file", files.files[0]);
		}
		
		try {
			let r = await fetch(appUrl('/service/email/message.do'), {
				method: 'POST',
				body: fd
			});
			
			let json = await r.json();
			
			if (json.success) {
				if (opts.sent) {
					reportUserMessage( 'Mail verstuurd' );
					gotoRoute( '/email/view/?id=' + json.emailMessageId );
				}
				else {
					reportUserMessage('Bericht opgeslagen');
					gotoRoute( '/email/edit/?id=' + json.emailMessageId );
				}
			}
			else {
				if (json.emailMessageId) {
					gotoRoute( '/email/view/?id=' + json.emailMessageId );
				}
				reportUserError( _('Error') + ': ' + json.message);
			}
		}
		catch (err) {
			console.log(err);
			reportUserError( _('Error') + ': ' + err);
		}
		
		hideLoadingForm( '#frmEmailEdit' );
	}
	
	delete_Click() {
		
		showConfirmation(_('Delete e-mail'), _('Are you sure to delete this email?'), async () => {
			showLoadingForm( '#frmEmailEdit' );
			
			let r = await postJson( '/service/email/message.do', {
				a: 'deleteMail',
				emailId: this.email.emailMessageId
			});
			
			let json = await r.json();
			
			if (!json.success) {
				reportUserError( json && json.message ? json.message : r );
				return;
			}
			
			reportUserMessage( _('E-mail deleted') );
			gotoRoute( '/email/' );
		});
	}
	
	
	sendMessage() {
		
		showConfirmation('Mail versturen', 'Weet je zeker dat je de mail wilt versturen?', function() {
			this.save_Click({send: 1});
		}.bind(this));
		
		
	}
	
}



